string GetDescription()
{
	return "Creates a harmony that repeats ina cycle of 2 bars";
}

struct Offset
{
	int bar;
	double pos;	
};

void GenerateHarmony(UniquePart @up)
{
	int chords = RndInt(2,3);
	int[] basis(chords);
	
	if (RndInt(0,1) == 0)	// tonic on the end
	{
		basis[chords-1] = 1;	
		
		if (chords == 2)
		{
			basis[0] = RndInt(3,6);	
		}
		else
		{
			basis[0] = RndInt(2,6);	
			do
			{
				basis[1] = RndInt(3,6);	
			}
			while (basis[0] == basis[1]);
		}
	}
	else // tonic on the front
	{
		basis[0] = 1;	
		
		if (chords == 2)
		{
			basis[1] = RndInt(3,6);	
		}
		else
		{
			basis[2] = RndInt(3,6);	
			do
			{
				basis[1] = RndInt(2,6);	
			}
			while (basis[1] == basis[2]);
		}
	}
	
	Offset[] pattern(chords);
	
	pattern[0].bar = 0;
	pattern[0].pos = 0;
	
	if (chords == 2)
	{
		if (RndInt(0,1) == 0)
		{
			pattern[1].bar = 1;
			pattern[1].pos = 0;
		}
		else
		{
			pattern[1].bar = 0;
			pattern[1].pos = up.GetMetrum()-1;
		}	
	}
	else
	{
		if (RndInt(0,1) == 0)
		{
			pattern[1].bar = 0;
			if (up.GetMetrum() == 2) pattern[1].pos = 1;
			else if (up.GetMetrum() == 3) pattern[1].pos = 2;
			else if (up.GetMetrum() == 4) pattern[1].pos = 2;
			else if (up.GetMetrum() == 5) pattern[1].pos = 3;
			else up.GetMetrum()-2;
			pattern[2].bar = 1;
			pattern[2].pos = 0;
		}
		else
		{
			pattern[1].bar = 0;
			if (up.GetMetrum() < 5) pattern[1].pos = up.GetMetrum()-1;
			else pattern[1].pos = up.GetMetrum()-2;
			pattern[2].bar = 1;
			pattern[2].pos = 1;
		}
	}
	
	for (int i = 0; i < up.GetBars(); i+=2)
	{
		if (i+2 >= up.GetBars() && up.EndsSong() && RndInt(0,3) != 0)
		{
			if (RndInt(0,1) == 0) basis[chords-2] = 5;
			basis[chords-1] = 1;
		}
				
		for (int c = 0; c < chords; c++)
		{
			up.AddHarmonic(CreateTime(i + pattern[c].bar, pattern[c].pos), basis[c], "135");		
		}
	}
		
}